/*
 * Decompiled with CFR 0.152.
 */
package autocalib;

import autocalib.MainFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import javax.swing.JOptionPane;

public class SerialComm
implements SerialPortEventListener {
    static CommPortIdentifier portId;
    static CommPortIdentifier saveportId;
    static Enumeration portList;
    InputStream inputStream;
    SerialPort serialPort;
    static int[] dataAcquired;
    byte[] readBuffer = new byte[64];
    byte[] readBufferTMP = new byte[64];
    static int flagRX;
    static int PACKETRECEIVED;
    static int updateDataFlag;
    static OutputStream outputStream;
    static boolean outputBufferEmptyFlag;
    static int serialListenerState;
    static int numBytesRead;
    static int numBytesToBeRead;

    public void configureCOM(int baudRate) {
        block3: {
            String defaultPort;
            block2: {
                defaultPort = null;
                defaultPort = "COM".concat(String.valueOf(String.valueOf(MainFrame.com_cfg)));
                if (MainFrame.com_cfg == "0" || !this.checkPort(defaultPort, baudRate)) break block2;
                this.manageOutputStream();
                break block3;
            }
            if (this.checkPort(baudRate)) break block3;
            defaultPort = SerialComm.choosePort(baudRate);
            if (this.checkPort(defaultPort, baudRate)) {
                this.manageOutputStream();
            } else {
                System.exit(-1);
            }
        }
    }

    public void serialEvent(SerialPortEvent event) {
        boolean n = false;
        int numBytes = 0;
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                try {
                    int i;
                    if (serialListenerState == 0) {
                        for (i = 0; i < 64; ++i) {
                            SerialComm.dataAcquired[i] = 0;
                        }
                        for (i = 0; i < 64; ++i) {
                            this.readBuffer[i] = 0;
                        }
                        for (i = 0; i < 64; ++i) {
                            this.readBufferTMP[i] = 0;
                        }
                        if (flagRX == 0) {
                            numBytesToBeRead = 6;
                        } else if (flagRX == 1) {
                            numBytesToBeRead = 58;
                        } else if (flagRX >= 2 && flagRX < 55) {
                            numBytesToBeRead = 10;
                        } else if (flagRX == 55) {
                            numBytesToBeRead = 7;
                        }
                        numBytesRead = 0;
                    }
                    numBytes = this.inputStream.read(this.readBufferTMP);
                    for (i = 0; i < numBytes; ++i) {
                        this.readBuffer[i + SerialComm.numBytesRead] = this.readBufferTMP[i];
                    }
                    if ((numBytesRead += numBytes) >= numBytesToBeRead) {
                        for (i = 0; i < numBytesToBeRead - 8; ++i) {
                            SerialComm.dataAcquired[i] = this.readBuffer[i + 6];
                            if (dataAcquired[i] >= 0) continue;
                            SerialComm.dataAcquired[i] = dataAcquired[i] + 256;
                        }
                        flagRX = PACKETRECEIVED;
                        serialListenerState = 2;
                        break;
                    }
                    serialListenerState = 1;
                }
                catch (IOException iOException) {}
                break;
            }
        }
    }

    static String choosePort(int baudRate) {
        Object[] options = new Object[]{"COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8"};
        int n = JOptionPane.showOptionDialog(null, MainFrame.langMan.getString(27), MainFrame.langMan.getString(27), 1, 3, null, options, options[0]);
        if (n == 0) {
            return "COM1";
        }
        if (n == 1) {
            return "COM2";
        }
        if (n == 2) {
            return "COM3";
        }
        if (n == 3) {
            return "COM4";
        }
        if (n == 4) {
            return "COM5";
        }
        if (n == 5) {
            return "COM6";
        }
        if (n == 6) {
            return "COM7";
        }
        if (n == 7) {
            return "COM8";
        }
        return null;
    }

    public boolean checkPort(int baudRate) {
        String comPort = "";
        boolean portFound = false;
        portList = CommPortIdentifier.getPortIdentifiers();
        if (!portList.hasMoreElements()) {
            JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(28), MainFrame.langMan.getString(29), 1);
        }
        for (int n = 0; n <= 7; ++n) {
            while (portList.hasMoreElements()) {
                int count;
                portId = (CommPortIdentifier)portList.nextElement();
                if (n == 0) {
                    comPort = "COM1";
                } else if (n == 1) {
                    comPort = "COM2";
                } else if (n == 2) {
                    comPort = "COM3";
                } else if (n == 3) {
                    comPort = "COM4";
                } else if (n == 4) {
                    comPort = "COM5";
                } else if (n == 5) {
                    comPort = "COM6";
                } else if (n == 6) {
                    comPort = "COM7";
                } else if (n == 7) {
                    comPort = "COM8";
                }
                if (portId.getPortType() != 1 || !portId.getName().equals(comPort)) continue;
                this.initSettingPort(baudRate);
                this.manageOutputStream();
                flagRX = 0;
                this.connect();
                for (count = 0; flagRX != PACKETRECEIVED && count < 8; ++count) {
                    this.wait_mS(50);
                }
                if (count < 10 && this.readBuffer[0] == 0 && this.readBuffer[1] == 6 && this.readBuffer[2] == 9 && this.readBuffer[3] == 6) {
                    portFound = true;
                    return true;
                }
                this.serialPort.close();
            }
            portList = CommPortIdentifier.getPortIdentifiers();
        }
        if (!portFound) {
            JOptionPane.showMessageDialog(null, "Select Port Manually", "Port not found automatically", 1);
        }
        return false;
    }

    public boolean checkPort(String defaultPort, int baudRate) {
        boolean portFound = false;
        portList = CommPortIdentifier.getPortIdentifiers();
        if (!portList.hasMoreElements()) {
            JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(28), MainFrame.langMan.getString(29), 1);
        }
        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1 || !portId.getName().equals(defaultPort)) continue;
            portFound = true;
            this.initSettingPort(baudRate);
            return true;
        }
        if (!portFound) {
            // empty if block
        }
        return false;
    }

    public void initSettingPort(int baudRate) {
        try {
            this.serialPort = (SerialPort)portId.open("SimpleReadApp", 2000);
            this.inputStream = this.serialPort.getInputStream();
            this.serialPort.addEventListener(this);
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.setSerialPortParams(baudRate, 8, 1, 0);
        }
        catch (PortInUseException e) {
            JOptionPane.showMessageDialog(null, "Port In Use Exception");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "IO Exception");
        }
        catch (TooManyListenersException e) {
        }
        catch (UnsupportedCommOperationException e) {
            JOptionPane.showMessageDialog(null, "Unsupported Comm Operation Exception");
        }
    }

    public void reOpenPort(int baudRate) {
        boolean portFound = false;
        MainFrame.comPort.serialPort.close();
        MainFrame.comPort.configureCOM(baudRate);
    }

    public void setBaudratePort(int baudrate) {
        try {
            this.serialPort = (SerialPort)portId.open("SimpleReadApp", 2000);
            this.inputStream = this.serialPort.getInputStream();
            this.serialPort.addEventListener(this);
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.setSerialPortParams(MainFrame.baudrate_cfg, 8, 1, 0);
        }
        catch (PortInUseException e) {
            JOptionPane.showMessageDialog(null, "Port In Use Exception");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "IO Exception");
        }
        catch (TooManyListenersException e) {
        }
        catch (UnsupportedCommOperationException e) {
            JOptionPane.showMessageDialog(null, "Unsupported Comm Operation Exception");
        }
    }

    public void manageOutputStream() {
        try {
            outputStream = this.serialPort.getOutputStream();
            this.serialPort.notifyOnOutputEmpty(true);
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            System.out.println("Error setting event notification");
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void writeOnSerial(byte[] cmd) {
        try {
            serialListenerState = 0;
            SerialComm.CRC16(cmd);
            outputStream.write(cmd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendSettingBaudRate(int baudrate) {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        byte[] baudrate_Block = new byte[]{0, 6, 10, (byte)baudrate, CRC_MSB, CRC_LSB};
        this.writeOnSerial(baudrate_Block);
    }

    public void connect() {
        byte[] connect_Block = new byte[]{0, 6, 9, 1, 39, -111};
        this.writeOnSerial(connect_Block);
    }

    public void disconnect() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        byte[] disconnect_Block = new byte[]{0, 6, 9, 0, CRC_MSB, CRC_LSB};
        this.writeOnSerial(disconnect_Block);
    }

    public void getAcqBenz() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        byte[] AcqBenz = new byte[]{0, 11, 5, 0, 64, 0, 50, 0, 50, CRC_MSB, CRC_LSB};
        this.writeOnSerial(AcqBenz);
    }

    public void getRPM() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        byte[] msgRPM = new byte[]{0, 11, 5, 0, 0, 98, 2, 0, 2, CRC_MSB, CRC_LSB};
        this.writeOnSerial(msgRPM);
    }

    public void getLambda() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        byte[] msgLambda = new byte[]{0, 11, 5, 0, 0, -38, 2, 0, 2, CRC_MSB, CRC_LSB};
        this.writeOnSerial(msgLambda);
    }

    public void getMAP() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        byte[] msgMAP = new byte[]{0, 11, 5, 0, 0, -66, 2, 0, 2, CRC_MSB, CRC_LSB};
        this.writeOnSerial(msgMAP);
    }

    public void getEngineStateMach() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        byte[] msgESM = new byte[]{0, 11, 5, 0, 1, 68, 2, 0, 2, CRC_MSB, CRC_LSB};
        this.writeOnSerial(msgESM);
    }

    public void resetAutoCalibUP() {
        byte CRC_MSB = -87;
        byte CRC_LSB = -126;
        byte[] resetCmd = new byte[]{0, 12, 2, 0, 6, -77, 1, 0, 1, 1, CRC_MSB, CRC_LSB};
        this.writeOnSerial(resetCmd);
    }

    public void resetAutoCalibDOWN() {
        byte CRC_MSB = 104;
        byte CRC_LSB = 66;
        byte[] resetCmd = new byte[]{0, 12, 2, 0, 6, -77, 1, 0, 1, 0, CRC_MSB, CRC_LSB};
        this.writeOnSerial(resetCmd);
    }

    public void correct1() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        String perc = MainFrame.MainF.C1jTextField.getText();
        int PERC = 0;
        if (perc.compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(26));
        } else {
            PERC = Integer.parseInt(perc);
            byte[] correct1Cmd = new byte[]{0, 12, 2, 0, 6, -88, 1, 0, 1, (byte)PERC, CRC_MSB, CRC_LSB};
            if (PERC <= 100 || PERC < -100) {
                this.writeOnSerial(correct1Cmd);
            } else {
                JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(26));
            }
        }
    }

    public void correct2() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        String perc = MainFrame.MainF.C2jTextField.getText();
        if (perc.compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(26));
        } else {
            int PERC = Integer.parseInt(perc);
            byte[] correct2Cmd = new byte[]{0, 12, 2, 0, 6, -87, 1, 0, 1, (byte)PERC, CRC_MSB, CRC_LSB};
            if (PERC <= 100 || PERC < -100) {
                this.writeOnSerial(correct2Cmd);
            } else {
                JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(26));
            }
        }
    }

    public void sendRPM_OL() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        String rpm = MainFrame.MainF.RPMOPjTextField.getText();
        if (rpm.compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(26));
        } else {
            int RPM = Integer.parseInt(rpm);
            int RPMMSB = RPM / 256;
            int RPMLSB = RPM - RPMMSB * 256;
            byte[] rpmCmd = new byte[]{0, 13, 2, 0, 6, -82, 2, 0, 2, (byte)RPMLSB, (byte)RPMMSB, CRC_MSB, CRC_LSB};
            if (RPM >= 0) {
                this.writeOnSerial(rpmCmd);
            } else {
                JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(26));
            }
        }
    }

    public void sendMAP_OL() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        String map = MainFrame.MainF.MAPOPjTextField.getText();
        if (map.compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(26));
        } else {
            int MAP = Integer.parseInt(map);
            int MAPMSB = MAP / 256;
            int MAPLSB = MAP - MAPMSB * 256;
            byte[] mapCmd = new byte[]{0, 13, 2, 0, 6, -80, 2, 0, 2, (byte)MAPLSB, (byte)MAPMSB, CRC_MSB, CRC_LSB};
            if (MAP >= 0) {
                this.writeOnSerial(mapCmd);
            } else {
                JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(26));
            }
        }
    }

    public void correctOL() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        String perc = MainFrame.MainF.CorrettoreOLjTextField.getText();
        int PERC = Integer.parseInt(perc);
        byte[] correct2Cmd = new byte[]{0, 12, 2, 0, 6, -84, 1, 0, 1, (byte)PERC, CRC_MSB, CRC_LSB};
        if (perc.compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(26));
        } else if (PERC <= 100 || PERC < -100) {
            this.writeOnSerial(correct2Cmd);
        } else {
            JOptionPane.showMessageDialog(null, MainFrame.langMan.getString(26));
        }
    }

    public void buttSaver() {
        byte CRC_MSB = 104;
        byte CRC_LSB = 66;
        byte[] bsCmd = new byte[]{0, 12, 2, 0, 6, -86, 1, 0, 1, 1, CRC_MSB, CRC_LSB};
        this.writeOnSerial(bsCmd);
    }

    public void putEngineSize() {
        byte CRC_MSB = 1;
        byte CRC_LSB = 1;
        int cilindrata = Integer.parseInt(MainFrame.MainF.CilindratajTextField.getText());
        int cilindrataMSB = cilindrata / 256;
        int cilindrataLSB = cilindrata - cilindrataMSB * 256;
        byte[] cilindrataCmd = new byte[]{0, 13, 2, 0, 6, -92, 2, 0, 2, (byte)cilindrataLSB, (byte)cilindrataMSB, CRC_MSB, CRC_LSB};
        this.writeOnSerial(cilindrataCmd);
    }

    public void putCylinders() {
        byte CRC_MSB = 1;
        byte CRC_LSB = 1;
        byte cilindri = 0;
        if (MainFrame.MainF.CyljComboBox.getSelectedIndex() == 0) {
            cilindri = 3;
        } else if (MainFrame.MainF.CyljComboBox.getSelectedIndex() == 1) {
            cilindri = 4;
        } else if (MainFrame.MainF.CyljComboBox.getSelectedIndex() == 2) {
            cilindri = 6;
        } else if (MainFrame.MainF.CyljComboBox.getSelectedIndex() == 3) {
            cilindri = 8;
        }
        byte[] cilindriCmd = new byte[]{0, 13, 2, 0, 6, -90, 2, 0, 2, cilindri, 0, CRC_MSB, CRC_LSB};
        this.writeOnSerial(cilindriCmd);
    }

    public void putGain() {
        byte CRC_MSB = 1;
        byte CRC_LSB = 1;
        int gain = (int)(Float.parseFloat(MainFrame.MainF.gainTextField.getText()) * (float)128);
        int gainMSB = gain / 256;
        int gainLSB = gain - gainMSB * 256;
        byte[] gainCmd = new byte[]{0, 13, 2, 0, 6, -76, 2, 0, 2, (byte)gainLSB, (byte)gainMSB, CRC_MSB, CRC_LSB};
        this.writeOnSerial(gainCmd);
    }

    public void putOffset() {
        byte CRC_MSB = 1;
        byte CRC_LSB = 1;
        int offset = (int)(Float.parseFloat(MainFrame.MainF.offsetTextField.getText()) * (float)128);
        int offsetMSB = offset / 256;
        int offsetLSB = offset - offsetMSB * 256;
        byte[] offsetCmd = new byte[]{0, 13, 2, 0, 6, -72, 2, 0, 2, (byte)offsetLSB, (byte)offsetMSB, CRC_MSB, CRC_LSB};
        this.writeOnSerial(offsetCmd);
    }

    public void switchToManual() {
        byte CRC_MSB = 104;
        byte CRC_LSB = 66;
        byte box = 0;
        if (MainFrame.MainF.Manual.isSelected()) {
            box = 1;
            MainFrame.MainF.AjTextField.setText("");
            MainFrame.MainF.BjTextField.setText("");
            MainFrame.MainF.A_initjTextField.setText("");
            MainFrame.MainF.B_initjTextField.setText("");
        }
        byte[] manualCmd = new byte[]{0, 12, 2, 0, 6, -68, 1, 0, 1, box, CRC_MSB, CRC_LSB};
        this.writeOnSerial(manualCmd);
    }

    public void stopGasCorrection() {
        byte CRC_MSB = 104;
        byte CRC_LSB = 66;
        byte[] stopCmd = new byte[]{0, 12, 2, 0, 6, -66, 1, 0, 1, 1, CRC_MSB, CRC_LSB};
        this.writeOnSerial(stopCmd);
    }

    public void setSizeInj() {
        byte CRC_MSB = 1;
        byte CRC_LSB = 1;
        byte sizeInj = 0;
        sizeInj = (byte)MainFrame.MainF.InjjComboBox.getSelectedIndex();
        byte[] sizeInjCmd = new byte[]{0, 13, 2, 0, 6, -78, 2, 0, 2, sizeInj, 0, CRC_MSB, CRC_LSB};
        this.writeOnSerial(sizeInjCmd);
    }

    public void setAutoMap(byte strategies) {
        byte CRC_MSB = 1;
        byte CRC_LSB = 1;
        int inttosend = strategies | 0x40;
        byte[] setAutoMap = new byte[]{0, 12, 2, 0, 6, -96, 1, 0, 1, (byte)inttosend, CRC_MSB, CRC_LSB};
        this.writeOnSerial(setAutoMap);
    }

    public void getEngineSize() {
        byte CRC_MSB = 1;
        byte CRC_LSB = 1;
        byte[] GetEngineSizeCmd = new byte[]{0, 11, 1, 0, 6, -92, 2, 0, 2, CRC_MSB, CRC_LSB};
        this.writeOnSerial(GetEngineSizeCmd);
    }

    public void getCylinders() {
        byte CRC_MSB = 1;
        byte CRC_LSB = 1;
        byte[] getCilindriCmd = new byte[]{0, 11, 1, 0, 6, -90, 2, 0, 2, CRC_MSB, CRC_LSB};
        this.writeOnSerial(getCilindriCmd);
    }

    public void getCalibData() {
        byte CRC_MSB = 0;
        byte CRC_LSB = 0;
        byte[] acalParams = new byte[]{0, 11, 1, 0, 6, -92, 50, 0, 50, CRC_MSB, CRC_LSB};
        this.writeOnSerial(acalParams);
    }

    public void getCorrect() {
        byte CRC_MSB = 1;
        byte CRC_LSB = 1;
        byte[] correct1Cmd = new byte[]{0, 11, 1, 0, 6, -88, 2, 0, 2, CRC_MSB, CRC_LSB};
        this.writeOnSerial(correct1Cmd);
    }

    void wait_mS(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private static byte[] crcAdjust(byte[] data) {
        byte[] dataAdjusted = data;
        int crcCode = 0;
        int P_16 = -24575;
        for (int i = 0; i < dataAdjusted.length - 2; ++i) {
            byte b = dataAdjusted[i];
            short tmp = (short)(crcCode ^ b);
            short d = (short)(tmp & 0xFF);
            short crcInt = 0;
            for (int j = 0; j < 8; ++j) {
                crcInt = (short)((crcInt ^ d) & 1) == 1 ? (short)(crcInt >> 1 ^ P_16) : (short)(crcInt >> 1);
                d = (short)(d >> 1);
            }
            crcCode = (short)(crcCode >> 8 ^ crcInt);
        }
        byte crcMsb = (byte)((crcCode & 0xFF00) >> 8);
        byte crcLsb = (byte)(crcCode & 0xFF);
        dataAdjusted[data.length - 2] = crcMsb;
        dataAdjusted[data.length - 1] = crcLsb;
        return dataAdjusted;
    }

    public static void CRC16(byte[] data) {
        int[] table = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};
        int crc = 0;
        boolean crcMSB = false;
        boolean crcLSB = false;
        for (int i = 0; i < data.length - 2; ++i) {
            byte b = data[i];
            crc = crc >>> 8 ^ table[(crc ^ b) & 0xFF];
        }
        data[data.length - 1] = (byte)(crc >> 8);
        data[data.length - 2] = (byte)crc;
    }

    static {
        dataAcquired = new int[64];
        flagRX = 0;
        PACKETRECEIVED = 100;
        updateDataFlag = 0;
        outputBufferEmptyFlag = false;
        serialListenerState = 0;
        numBytesRead = 0;
        numBytesToBeRead = 0;
    }
}

